---@class ShowMessageDialogEvent
ShowMessageDialogEvent = {}
local ShowMessageDialogEvent_mt = Class(ShowMessageDialogEvent, Event)

InitEventClass(ShowMessageDialogEvent, "ShowMessageDialogEvent")

function ShowMessageDialogEvent.emptyNew()
  fcDebug("VRE-emptyNew")
	return Event.new(ShowMessageDialogEvent_mt)
end

function ShowMessageDialogEvent.new(userId,infoText)
  fcDebug("VRE-new")
	local self = ShowMessageDialogEvent.emptyNew()
  self.userId = userId
  self.infoText = infoText

	return self
end

function ShowMessageDialogEvent:readStream(streamId, connection)
  fcDebug("VRE-readStream")
  -- Get data from clients
  self.userId = User.streamReadUserId(streamId)
  self.infoText = streamReadString(streamId)

	self:run(connection)
end

function ShowMessageDialogEvent:writeStream(streamId, connection)
  fcDebug("VRE-writeStream")
  -- Send data out to clients
  User.streamWriteUserId(streamId, self.userId)
  streamWriteString(streamId, self.infoText)

end

function ShowMessageDialogEvent:run(connection)
  fcDebug("VRE-run")
  if g_localPlayer.userId == self.userId then
    MessageDialog.show(self.infoText)
  end
end

function ShowMessageDialogEvent.sendEvent(userId,infoText)
  fcDebug("VRE-sendEvent")
  fcDebug(userId)
	if g_server ~= nil then
    if g_client:getServerConnection():getIsLocal() and g_dedicatedServer == nil then
      fcDebug("VRE Local Server Host")
      MessageDialog.show(infoText)
    else
      fcDebug("VRE Dedicated Server Host")
  		g_server:broadcastEvent(ShowMessageDialogEvent.new(userId,infoText))
    end
    return
	end
  fcDebug("VRE Client")
	-- g_client:getServerConnection():sendEvent(ShowMessageDialogEvent.new(userId,infoText))
  MessageDialog.show(infoText)
end
