--
-- main
-- 
-- Author: FSG Modding - DaVaR
-- Description: Loads the mod and such
-- Name: main
-- Hide: yes
--

local modDirectory = g_currentModDirectory or ""
local modName = g_currentModName or "unknown"
local modEnvironment

---Source files 
local sourceFiles = {
  -- Debug
  "scripts/Debug.lua",
  -- Main Classes
  "scripts/FarmCleanup.lua",
  -- Events
  "scripts/SettingEvent.lua",
  "scripts/ManualCleanEvent.lua",
  "scripts/hideMessageDialogEvent.lua",
  "scripts/showMessageDialogEvent.lua",
  "scripts/showDialogEvent.lua",
  -- Libraries
  "scripts/FS25ModPrefSaver.lua",
  -- Gui
  "gui/SettingsGui.lua",
  "gui/SettingsGuiInfoFrame.lua",
  "gui/SettingsGuiSettingsFrame.lua",
}

---Load all of the source files
for _, file in ipairs(sourceFiles) do
  source(modDirectory .. file)
end

---Load the mod
local function load(mission)
  assert(g_farmCleanup == nil)
  modEnvironment = FarmCleanup:new(mission, g_i18n, modDirectory, modName)
  getfenv(0)["g_farmCleanup"] = modEnvironment

  if mission:getIsClient() then
    addModEventListener(modEnvironment)
  end
end

---Unload the mod when the mod is unselected and savegame is (re)loaded or game is closed.
local function unload()
  removeModEventListener(modEnvironment)
  if modEnvironment ~= nil then
    modEnvironment = nil
    if g_farmCleanup ~= nil then
      getfenv(0)["g_farmCleanup"] = nil
    end
  end
end

---Init the mod.
local function init()
  -- Create folder for this mod if not one already
  local modSettingsFolderPath = getUserProfileAppPath()  .. "modSettings/FS25_FarmsCleanup"
  if ( not fileExists(modSettingsFolderPath) ) then createFolder(modSettingsFolderPath) end
  -- Create folder for logs is not one already
  local logsFolderPath = modSettingsFolderPath  .. "/Logs"
  if ( not fileExists(logsFolderPath) ) then createFolder(logsFolderPath) end
  -- Load before the mission is loaded
  Mission00.load = Utils.prependedFunction(Mission00.load, load)
  -- Unload mod on mission unload
  FSBaseMission.delete = Utils.appendedFunction(FSBaseMission.delete, unload)
  -- Runs when the game is finished loading or player leaves welcome screen after joining game
  FSBaseMission.onConnectionFinishedLoading = Utils.appendedFunction(FSBaseMission.onConnectionFinishedLoading, FarmCleanup.join)
  -- Saves current settings on save
  FSCareerMissionInfo.saveToXMLFile = Utils.appendedFunction(FSCareerMissionInfo.saveToXMLFile, FarmCleanup.saveToXMLFile)
end

--- Makes things tick
init()

