--[[
	anti-zkiv.lua
	
	Author: 	Azhur
	Date: 		23.03.2025
	Version: 	0.2
	
    If corresponding mods loaded:
    - Replaces Dewulf zkivSe with Dewulf Kwatro in all sets of mission vechicles, as it's almost not useable in singleplayer.
    - Adds sets of mission vechicles with ROPA Tiger6S Premium for vegetables harvest missions.
	Changelog:	v0.1 @23.03.2025 - initial implementation
                v0.2 @06.04.2025 - major rework to work without hard-coded dependencies
---------------------------------------------------------------------------------------------------------------------------
]]
--local remove_zkiv = false

CMV = {}

CMV.modDir = g_currentModDirectory;
CMV.kwatroLoaded = false
CMV.tigerLoaded = false

local CMV_mt = Class(CMV, Object)
InitObjectClass(CMV, "CMV")
function CMV.new(isServer, isClient, customMt)
    local self = Object.new(isServer, isClient, customMt or CMV_mt)
    return self
end

function CMV.loadMapData_append(self, xmlFile)
    if Utils.getNoNil(getXMLBool(xmlFile, "map.missions#enabled"), true) then
        print("anti-zkiv")
        local function replaceMissionVehicle(groupsTable, vehicleXML, vehicleXML_replace)
            for id, group in ipairs(groupsTable) do
                for _, vehicle in ipairs(group.vehicles) do
                    if vehicle.filename == vehicleXML then
                        print("replace zkiv!!!")
                        print(vehicle.filename)
                        vehicle.filename = vehicleXML_replace
                        print(vehicle.filename)
                    end
                end
            end
        end
        if g_modIsLoaded["FS25_DewulfKwatro"] then
            print("kwatro mod loaded, replacing zkiv")
            replaceMissionVehicle(g_missionManager.missionVehicles.harvestMission.large, "data/vehicles/dewulf/zkivSe/zkivSe.xml", g_modsDirectory .. "FS25_DewulfKwatro/DewulfCarrot.xml")
            replaceMissionVehicle(g_missionManager.missionVehicles.harvestMission.medium, "data/vehicles/dewulf/zkivSe/zkivSe.xml", g_modsDirectory .. "FS25_DewulfKwatro/DewulfCarrot.xml")
            CMV.kwatroLoaded = true
        else
            print("kwatro mod not loaded")
        end
        if g_modIsLoaded["FS25_tiger6S_premium"] then
            print("tiger mod loaded, adding to missions")
            g_missionManager:loadVehicleGroups(CMV.modDir .. "missionVehicles_tiger6S_premium.xml", g_modsDirectory)
            CMV.tigerLoaded = true
        else
            print("tiger mod not loaded")
        end
        print("files test2")
        local allFiles = Files.new(CMV.confDirectory)
        for _, file in pairs(allFiles.files) do
            --print (file.filename)
            if file.filename:match("^missionVehicles_.*%.xml$") and not file.isDirectory then
                --print("match!")
                print(CMV.confDirectory .. file.filename)
                g_missionManager:loadVehicleGroups(CMV.confDirectory .. file.filename, g_modsDirectory)
            end
        end




    end
end

function CMV.onEventTest()
    --InfoDialog.show("Event Test", nil)
    if CMV.kwatroLoaded then
        --g_i18n:getText("cmv_kwatro_loaded")
        g_currentMission:addIngameNotification(FSBaseMission.INGAME_NOTIFICATION_OK, g_i18n:getText("cmv_kwatro_loaded"))
    else
        g_currentMission:addIngameNotification(FSBaseMission.INGAME_NOTIFICATION_CRITICAL, g_i18n:getText("cmv_kwatro_not_loaded"))
    end
    if CMV.tigerLoaded then
        g_currentMission:addIngameNotification(FSBaseMission.INGAME_NOTIFICATION_OK, g_i18n:getText("cmv_tiger_loaded"))
    else
        g_currentMission:addIngameNotification(FSBaseMission.INGAME_NOTIFICATION_CRITICAL, g_i18n:getText("cmv_tiger_not_loaded"))
    end
    --g_currentMission:addIngameNotification(FSBaseMission.INGAME_NOTIFICATION_OK, "Event test!")
end


function CMV:init()
    -- create folders, in case they do not exist yet
    CMV.settingsDirectory = getUserProfileAppPath() .. "modSettings/"
    CMV.confDirectory = CMV.settingsDirectory .. "FS25_CMV/"
    createFolder(CMV.settingsDirectory)
    createFolder(CMV.confDirectory);

    MissionManager.loadMapData = Utils.appendedFunction(MissionManager.loadMapData, CMV.loadMapData_append)
    g_messageCenter:subscribeOneshot(MessageType.GUI_AFTER_CLOSE, CMV.onEventTest, self)
end

CMV.init()